<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreAssetsRequest;
use Illuminate\Support\Facades\Storage;
use App\Http\Requests\UpdateAssetsRequest;
use App\Imports\MassiveAssetImport;
use App\Models\AssetsMassiveRow;
use App\Models\Assets;
use App\Models\Customer;
use App\Models\Regime;
use App\Models\PartNumber;
use Illuminate\Http\Request;
use App\Models\MeasurementUnit;
use Illuminate\Support\Facades\Auth;
use App\Models\Bitacora;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Str;
use PDF;



class AssetsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $clientes = Customer::All();

        $cliente = $request->txtCliente ?? 0;
        $status = $request->txtStatus ?? '0';
        Bitacora::registrar('slog', Auth::user()->name ,'buscando'.$cliente);
        $desc = $request->txtDesc ?? "";
        $offset = $request->txtTab ?? "1"; //<-- tab debe venir del formulario y comienza en 1, representa los tab (paginacion) que queremos consultar, despues le restaremos 1 porque en el codigo lo necesitamos base 0 pero el usuario debe verlo en base 1
        $offset--;
        $items = 100;
        $result = $this->index_object($cliente, $desc, $offset, $items, $status);
        $assets = $result[0];
        $count = $result[1]/$items;

        $can_delete = Auth::user()->canDeleteAsset();
        $can_edit = Auth::user()->canEditAsset();

        return view('intern.assets.index', [
            'assets' => $assets,
            'tab' => $offset+1,
            'desc' => $desc,
            'clientes' => $clientes,
            'cliente' => $cliente,
            'status' => $status,
            'tab_count' => $count,
            'can_delete' => $can_delete,
            'can_edit' => $can_edit,
        ]);
    }

    public function index_object(string $cliente, string $desc, string $offset, string $items, string $status)
    {
        $obj = Assets::whereRaw(" ( descrip like '%".$desc."%' or asset like '%".$desc."%' or brand like '%".$desc."%' or model like '%".$desc."%' or serial like '%".$desc."%' or pedimento like '%".$desc."%' or factura like '%".$desc."%'  ) ");
        if($cliente != "0")
        {
            $obj->where('customer_id',$cliente);
        }
        if($status == "Salida")
        {
            $obj->where('status',$status);
        }
        if($status == "Entrada" || $status == "0")
        {
            $obj->where('status', '!=', 'Salida');
        }
        $total_count = $obj->count();
        $obj = $obj->skip($items*$offset)->take($items)->get();

        return [$obj,$total_count];
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $clientes = Customer::All();
        $regimes = Regime::All();

        return view('intern.assets.create', [
            'asset' => null,
            'clientes' => $clientes,
            'regimes' => $regimes,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreAssetsRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreAssetsRequest $request)
    {
        $accion = "Update Asset";
        $asset = Assets::where('asset',$request->txtAsset)->where([["customer_id",$request->txtCliente]])->first();

        if($request->txtStatus == 'Salida')
        {
            $this->registrarSalida($asset,$request->txtMotivoDeSalida ?? "");
            return redirect('/int/asset/'.$asset->id.'/edit_existing');
        }

        if(!$asset)
        {
            $asset = new Assets;
            $accion = "Create Asset";
        }

        //registrar en la bitacora
        Bitacora::registrar($accion, Auth::user()->name ,$request->txtAsset . " [Desc:" . $asset->asset . "=>" . $request->txtDesc . "]");
        
        $asset->asset = $request->txtAsset;
        $asset->customer_id = $request->txtCliente;
        $asset->descrip = $request->txtDesc ?? "";
        $asset->regimen = $request->txtRegimen ?? "";
        $asset->brand = $request->txtMarca ?? "";
        $asset->model = $request->txtModelo ?? "";
        $asset->serial = $request->txtSerie ?? "";
        $asset->ubicacion = $request->txtUbicacion ?? "";
        $asset->pedimento = $request->txtPedimento ?? "";
        $asset->factura = $request->txtFactura ?? "";
        $asset->fecha_pedimento_factura = $request->txtFecha;
        $asset->bandera = $request->txtBandera ?? "";
        $asset->observations = $request->txtObservaciones ?? "";
        $asset->motivo_de_salida = "";
        $asset->status = "Entrada";
        $asset->user = Auth::user()->name;

        $asset->save();
        $i = 0;
        foreach ($request?->file('fotos')??[] as $file) 
        {
            $i++;
            Storage::put('/public/assets_files/'.$asset->id.'/images/'.time().'_'.$i.'.'.$file->extension(), file_get_contents($file), 'public');
        }
        $i = 0;
        foreach ($request?->file('archivos')??[] as $file) 
        {
            $i++;
            Storage::put('/public/assets_files/'.$asset->id.'/files/'.time().'_'.$i.'.'.$file->extension(), file_get_contents($file), 'public');
        }
        return redirect('/int/asset/'.$asset->id.'/edit_existing');
    }

    public function registrarSalida($asset,$motivo)
    {
        //registrar en la bitacora
        Bitacora::registrar('Salida de Activo', Auth::user()->name ,$asset->asset . " cliente:" . $asset->cliente);
        $asset->motivo_de_salida = $motivo;
        $asset->status = "Salida";
        $asset->save();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Assets  $assets
     * @return \Illuminate\Http\Response
     */
    public function show(Assets $assets)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Assets  $assets
     * @return \Illuminate\Http\Response
     */
    public function edit(Assets $assets)
    {
        //

    }
    public function edit_existing(string $asset_id)
    {
        $clientes = Customer::All();
        $regimes = Regime::All();
        $asset = Assets::find($asset_id);

        return view('intern.assets.create', [
            'asset' => $asset,
            'clientes' => $clientes,
            'cliente' => $asset->customer_id,
            'regimes' => $regimes,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateAssetsRequest  $request
     * @param  \App\Models\Assets  $assets
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateAssetsRequest $request, Assets $assets)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Assets  $assets
     * @return \Illuminate\Http\Response
     */
    public function destroy(Assets $asset)
    {
        Bitacora::registrar('Eliminar Asset', Auth::user()->name ,"asset:" . $asset->asset . " desc=>" . $asset->descrip);
        $asset->delete();
        return "Eliminado!";
    }

    public function deleteImgAsset(Request $request)
    {
        Bitacora::registrar('Eliminar foto de Asset', Auth::user()->name , 'asset id:' . $request->asset_id . ' ' . $request->asset_foto_name);
        Storage::delete('/public/assets_files/'.$request->asset_id.'/images/'.$request->asset_foto_name);
        return redirect('/int/asset/'.$request->asset_id.'/edit_existing'); 
    }

    public function masiva($cliente)
    {
        $clientes = Customer::All();
        
        return view('intern.assets.masiva', [
                'clientes' => $clientes,
                'cliente' => $cliente,
            ]);
    }

    public function upload_masiva(Request $request)
    {
        $content = file_get_contents($request->file('file'));
        // generamos un nombre aleatorio para nombrar el excel mientras leemos sus datos
        // pero este mismo string nos servira para identificar esta importacion
        $temporary_name = Str::random(10);
        $path = '/public/assets_files/'.$temporary_name.'.xlsx';
        Storage::put($path, $content);
        $data = Excel::toArray(new MassiveAssetImport(), $path);
        $obj_data = array();
        $first_iteration = true;
        $is_valid = true;

        foreach ($data[0] as $row) 
        {
            $validation = "good"; // <- good if everythig ok, warning if part_number no existe, danger para cualquier error de conversion
            $validation_msg = ""; // explicacion sobre los errores encontrados
            if($first_iteration || strlen(trim($row[0])) < 3) // vamo a saltarnos la primera fila porque son los encabezados en el excel, tambien saltamos si la celda no parece un asset valido
            {
                $first_iteration = false;
                continue;
            }
            $obj_row = new AssetsMassiveRow;
            $obj_row->asset = trim($row[0]);
            $validate_asset = Assets::where('asset',$obj_row->asset)->first();
            if(!is_null($validate_asset))
            {
                $validation = "danger";
                $is_valid = false;
                $validation_msg .= "Este <strong>Asset</strong> ya se encuentra registrado.<br>  ";
            }


            $obj_row->descrip = trim($row[1]);
            $obj_row->regimen = trim($row[2]);

            $obj_row->brand = trim($row[3]);
            $obj_row->model = trim($row[4]);
            $obj_row->serial = trim($row[5]);

            $validate_mms = Assets::whereRaw(" ( brand = '".$obj_row->brand."' and model = '".$obj_row->model."' and serial = '".$obj_row->serial."' ) ")->first();

            if(!is_null($validate_mms))
            {
                $validation = "danger";
                $is_valid = false;
                $validation_msg .= "La convinacion de <strong>Marca, Modelo y Serie</strong> ya se encuentra registrada.<br>  ";
            }

            $obj_row->ubicacion = trim($row[6]);
            $obj_row->pedimento = trim($row[7]);
            $obj_row->factura = trim($row[8]);
            
            $obj_row->fecha_pedimento_factura = trim($row[9]);
            if(!is_numeric($obj_row->fecha_pedimento_factura)||(empty($obj_row->fecha_pedimento_factura)==true))
            {
                $validation = "danger";
                $is_valid = false;
                $validation_msg .= " Campo <strong>Fecha Pedimento a Facture</strong> no se identfica como fecha o está vacío<br> ";
            } else {
                // el campo fecha si es numerico pero excel lo guarda en otro formato, debemos convertirlo
                // explicacion: Excel guarda fechas en forma de un numero para representar dias
                // debemos restar 25569 y luego multiplicar por la cantidad de segundos en un dia
                // esto porque php nos pide las fechas como un numero que representa los segundos trascurridos desde epoch
                $fecha_en_segundos = ($obj_row->fecha_pedimento_factura - 25569) * 86400;
                // ahora nuestra tabla debe estar en human_readable_format
                $obj_row->fecha_pedimento_factura = gmdate("m-d-Y", $fecha_en_segundos);
            }

            $obj_row->bandera = trim($row[10]);
            $obj_row->bandera = strtoupper($obj_row->bandera);
            // los valores validos para bandera son ROJO, AMARILLO, VERDE
            if($obj_row->bandera != 'ROJO' && $obj_row->bandera != 'AMARILLO' && $obj_row->bandera != 'VERDE')
            {
                $validation = "danger";
                $is_valid = false;
                $validation_msg .= " Campo <strong>Bandera</strong> solo admite: Rojo, Amarillo o Verde<br> ";
            }

            $obj_row->observations = trim($row[11]);
            $obj_row->validation = $validation;   
            $obj_row->validation_msg = $validation_msg;
            // usaremos este nombre aleatorio para manejar facilmente todas las lineas the esta importacion
            $obj_row->massive_import_id = $temporary_name; 
            $obj_row->save();
            array_push($obj_data,$obj_row);
            unset($obj_row);
        }
        Storage::delete($path);
        $clientes = Customer::All();
        if(sizeof($obj_data)) 
        {
            if($is_valid)
            {
                return view('intern.assets.masiva', [
                    'excel_data' => $obj_data,
                    'clientes' => $clientes,
                    'cliente' => $request->txtCliente,
                    'is_valid' => $is_valid,
                    'import_id' => $temporary_name
                ]);
            }else{
                return view('intern.assets.masiva', [
                    'excel_data' => $obj_data,
                    'clientes' => $clientes,
                    'cliente' => $request->txtCliente,
                    'import_id' => $temporary_name
                ]);
            }
            
        } 


    }
    public function guardarMasiva($import_id, $cliente_id)
    {
        foreach (AssetsMassiveRow::where('massive_import_id',$import_id)->get() as $row) {
            $asset = new Assets;
            $asset->asset = $row->asset;
            $asset->customer_id = $cliente_id;
            $asset->descrip = $row->descrip ?? "";
            $asset->regimen = $row->regimen ?? "";
            $asset->brand = $row->brand ?? "";
            $asset->model = $row->model ?? "";
            $asset->serial = $row->serial ?? "";
            $asset->ubicacion = $row->ubicacion ?? "";
            $asset->pedimento = $row->pedimento ?? "";
            $asset->factura = $row->factura ?? "";
            $asset->fecha_pedimento_factura = date("Y-m-d H:i:s", strtotime($row->fecha_pedimento_factura));
            $asset->bandera = $row->bandera ?? "";
            $asset->observations = $row->observations ?? "";
            $asset->user = Auth::user()->name;
            $asset->save();
            unset($asset);
        }
        return redirect('/int/assets/'); 

    }

    public function imprimir_etiquetas(string $asset_id)
    {
        $asset =  Assets::find($asset_id);
        //Imprimir etiquetas
        // 1 inch = 72 point

        // //dimensiones:
        // //  1.25 x 3.5 pugadas
        // //  90   x 252 points
        // $customPaper = array(0,0,90.00,252.00);
        // $pdf = PDF::loadView('intern.entradas.etiquetas', compact('entrada'))->setPaper($customPaper, 'landscape');

        //dimensiones:
        //  2.25 x 4 pugadas
        //  162   x 288 points
        $customPaper = array(0,0,162.00,288.00);
        $pdf = PDF::loadView('intern.assets.etiquetas2x4', compact('asset'))->setPaper($customPaper, 'landscape');


        return $pdf->stream();
    }
}
