<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAssetsTable extends Migration
{
    /**
     * Run the migrations.
     * php artisan make:migration create_assets_table
     * PARA CORRER ESTA MIGRACION -> php artisan migrate --path=/database/migrations/2025_08_30_212333_create_assets_table.php
     * @return void
     */

    public function up()
    {
        Schema::connection('secondary_mysql')->create('assets', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('customer_id');
            $table->string('asset')->default("");
            $table->string('descrip')->default("");
            $table->string('regimen')->default("");
            $table->string('brand')->default("");
            $table->string('model')->default("");
            $table->string('serial')->default("");
            $table->string('observations',1024)->default("");
            $table->string('ubicacion')->default("");
            $table->string('pedimento')->default("");
            $table->string('factura')->default("");
            $table->timestamp('fecha_pedimento_factura')->nullable();
            $table->string('archivos')->default("");
            $table->string('fotos')->default("");
            $table->string('bandera')->default("");
            $table->string('status')->default("");
            $table->string('user')->default("");
            $table->string('motivo_de_salida')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('secondary_mysql')->dropIfExists('assets');
    }
}
