<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAssetsMassiveRowsTable extends Migration
{
    /**
     * Run the migrations.
     * PARA CORRER ESTA MIGRACION -> php artisan migrate --path=/database/migrations/2025_09_06_181414_create_assets_massive_rows_table.php
     * @return void
     */
    public function up()
    {
        Schema::connection('secondary_mysql')->create('assets_massive_rows', function (Blueprint $table) {
            $table->id();
            $table->string('massive_import_id')->default("");
            $table->string('asset')->default("");
            $table->string('descrip')->default("");
            $table->string('regimen')->default("");
            $table->string('brand')->default("");
            $table->string('model')->default("");
            $table->string('serial')->default("");
            $table->string('observations')->default("");
            $table->string('ubicacion')->default("");
            $table->string('pedimento')->default("");
            $table->string('factura')->default("");
            $table->string('fecha_pedimento_factura')->default("");
            $table->string('bandera')->default("");
            $table->string('status')->default("");
            $table->string('user')->default("");
            $table->string('validation')->default("");
            $table->string('validation_msg')->default("");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('secondary_mysql')->dropIfExists('assets_massive_rows');
    }
}
