@extends('layouts.common')
@section('headers')
<style>
    td, th
    {
        text-align:center;
    }
    .oversized-col
    {
        max-width:150px;
        overflow:hidden;
    }
</style>
@endsection
@section('content')
<!-- Page Heading -->
<header class="bg-white shadow">
    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Assets.
        </h2>
    </div>
</header>

<!-- Page Content -->

<div class="py-12">
<div class="max-w-full mx-auto sm:px-6 lg:px-8">
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
<div class="p-6 bg-white border-b border-gray-200">

        <form id = "frmAssets" action="/int/assets" method="get">
        <div class="row">
            <div class="col-lg-2 controlDiv" >
                <label class="form-label">Cliente:</label>
                <select class="form-select" id = "txtCliente" name = "txtCliente">
                <option value=0 selected></option>
                @foreach ($clientes as $clienteOp)
                <option value="{{ $clienteOp->id }}" @if ( $cliente == $clienteOp->id) selected @endif >{{ $clienteOp->name }}</option>
                @endforeach
                </select>
            </div>

            <div class="col-lg-2 controlDiv" style="">
                <label class="form-label">Asset / Descripción:</label>
                <input type="text" class="form-control" id="txtDesc" name="txtDesc" value="{{ $desc ?? '' }}">       
            </div>

            <div class="col-lg-3 controlDiv" >
                <label class="form-label">Salida:</label>
                <select class="form-select" id = "txtStatus" name = "txtStatus" onChange='onStatusChange(this)'>
                <option value=0 selected></option>
                    <option value="Entrada" @if ($status == '0') selected @endif></option>
                    <option value="Entrada" @if ($status == 'Entrada') selected @endif>No</option>
                    <option value="Salida" @if ($status == 'Salida') selected @endif>Si</option>
                </select>
            </div>

            <div class="col-lg-2 controlDiv" style="position:relative;top:30px;">
                <button type="button" class="btn btn-primary" onclick="buscar()">Buscar</button>     
            </div>
            <div class="col-lg-2 controlDiv" style="position:relative;top:30px;">
                <a href="/int/assets/create" class="btn btn-success" role="button" aria-pressed="true"><i class="fas fa-plus"></i></a>
            </div>
            
        </div>
        <br><br>

            <div class="row" >
                <input type="hidden" id="txtTab" name="txtTab" value="{{ $tab ?? 1}}">

                <div class="col-lg-10 controlDiv" style="overflow: auto; text-align:center; left:100px; position:relative;">
                    <div class="btn-group me-2" id="div_btns_partidas" role="group">
                    <button type='button' class='btn btn-outline-primary btnIncomeRow' onclick='goPrev()' id='btnTab_prev'><span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span></button>
                        @php
                        if(isset($tab_count))
                        {
                            for ($i = 1; $i <= $tab_count+1; $i++)
                            {
                                $active_tab = "";
                                if($tab == $i)
                                {
                                    $active_tab = "active";
                                }
                                echo "<button type='button' class='btn btn-outline-secondary btnIncomeRow ".$active_tab."' onclick='goTab(".$i.")' id='btnTab_".$i."' >".$i."</button>";
                            }
                        }
                        @endphp
                        <button type='button' class='btn btn-outline-primary btnIncomeRow' onclick='goNext()' id='btnTab_prev'><span aria-hidden="true">&raquo;</span><span class="sr-only">Previous</span></button>
                    </div>
                </div>
            </div>
            
        </form>

        <h5 class="separtor">Lista:</h5>



        <!-- como esta pantalla no contiene formularios debemos agregar uno para tener un token csrf-->
        <form method="DELETE">
        @csrf
        </form>
        <table class="table table-sm table-striped table-bordered table-hover">
            <thead>
                <tr>
                    <th scope="col">Asset</th>
                    <th scope="col">Cliente</th>
                    <th scope="col">Descripcion</th>
                    <th scope="col">Regimen</th>
                    <th scope="col">Marca</th>
                    <th scope="col">Modelo</th>
                    <th scope="col">Serie</th>
                    <th scope="col">Ubicacion</th>
                    <th scope="col">Pedimento</th>
                    <th scope="col">Factura</th>
                    @if ($can_edit) <th scope="col">Editar</th> @endif
                    @if ($can_delete) <th scope="col">Eliminar</th> @endif
                </tr>
            </thead>
            <tbody>
                @foreach ($assets as $asset)
                <tr id="row_{{ $asset->id }}">
                    <td style="font-size:0.9em">{{ $asset->asset }}</td>
                    <td>{{ $asset->customer->name }}</td>
                    <td style="font-size:0.8em; min-width:110px;">{{ $asset->descrip }}</td>
                    <td>{{ $asset->regimen }}</td>
                    <td>{{ $asset->brand }}</td>
                    <td>{{ $asset->model }}</td>
                    <td>{{ $asset->serial }}</td>
                    <td>{{ $asset->ubicacion }}</td>
                    <td>{{ $asset->pedimento }}</td>
                    <td>{{ $asset->factura }}</td>
                    @if ($can_edit) <td><a href="/int/asset/{{ $asset->id }}/edit_existing" class="btn btn-light" role="button" aria-pressed="true"><i class="fas fa-edit"></i></a></td> @endif
                    @if ($can_delete) <td><button class="btn btn-light" type='button' onclick="eliminar({{ $asset->id }})"><i class="fas fa-times" style="color:red"></i></button></td> @endif
                </tr>
                @endforeach
            </tbody>
        </table>
</div>
</div>
</div>
</div>
@endsection
@section('scripts')
<script>


function eliminar(id)
{
    if(!confirm("¿Desea eliminar el Asset?"))
    {
        return;
    }
    let token = $("[name='_token']").val();
    $.ajax(
        {
            url: "/int/assets/"+id,
            type: 'DELETE',
            data: {
                "_token": token,
            },
            success: function (response){
                showModal("Notificación",response);
                if(response == "Eliminado!")
                {
                    $("#row_"+id).remove();
                }
            }
        });
}

function buscar()
{
    $("#txtTab").val("1");
    $("#frmAssets").submit();
}
function goTab(tab)
{
    $("#txtTab").val(tab);
    $("#frmAssets").submit();
}
function goPrev()
{
    var current_tab = Number($("#txtTab").val());    
    $("#txtTab").val(current_tab-1);
    $("#frmAssets").submit();
}
function goNext()
{
    var current_tab = Number($("#txtTab").val());
    $("#txtTab").val(current_tab+1);
    $("#frmAssets").submit();
}
function editar(id)
{
    location.href = "/int/asset/"+id+"/edit";
}


</script>
@endsection