@extends('layouts.common')
@section('headers')
<style>
    th{
        text-align:center;
    }
</style>
@endsection
@section('content')
<!-- Page Heading -->
<header class="bg-white shadow">
    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Importe de Assets masivo
        </h2>
    </div>
</header>

<!-- Page Content -->
<div class="py-12">
    <div class="max-w-full mx-auto sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 bg-white border-b border-gray-200">

                <div class="row">

                    <div class="btn-group col-lg-4" role="group">
                        <button type="button" class="btn btn-outline-info" onclick="downloadTemplete()">Plantilla .xls <i class="fas fa-file-download"></i></button>
                        <button type="button" class="btn btn-outline-primary" onclick="cargar()">Cargar archivo <i class="fas fa-file-upload"></i></button>                        
                    </div>

                    <br>
                    <form id="frm_Cargar" action="/assets_massive_load" method="post" enctype="multipart/form-data">
                    <div style="display:none">
                        
                            @csrf
                            <input type="file" id="txtArchivo" name="file" accept=".xlsx" onchange="subirArchivo()">
                    </div>
                    <label class="form-label" style="color: #B22222"> <strong>*NOTA:</strong> <i lang="it">El archivo a cargar debe contener unicamente 1 pestaña</i></label>
                    <br>
                    <div class="col-lg-3 controlDiv" >
                        <label class="form-label">Cliente:</label>
                        <select class="form-select" id = "txtCliente" name = "txtCliente" @if (isset($cliente)) readonly @endif>
                        <option value=0 selected></option>
                        @foreach ($clientes as $clienteOp)
                        <option value="{{ $clienteOp->id }}" @php if(isset($cliente)){if($cliente == $clienteOp->id){echo "selected ";}else{echo "disabled ";}}@endphp >{{ $clienteOp->name }}</option>
                        @endforeach
                        </select>
                    </div>
                    </form>
                </div>

                <br><br>
                <div style="overflow-x: auto; white-space: nowrap;">
                <table class="table table-sm table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th scope="col"><i class="fas fa-exclamation-triangle"></i></th>
                            <th scope="col">Asset</th>
                            <th scope="col">Descripcion</th>
                            <th scope="col">Regimen</th>
                            <th scope="col">Marca</th>
                            <th scope="col">Modelo</th>
                            <th scope="col">Serie</th>
                            <th scope="col">Ubicacion</th>
                            <th scope="col">Pedimento</th>
                            <th scope="col">Factura</th>
                            <th scope="col">Fecha pedimento</th>
                            <th scope="col">Bandera</th>
                            <th scope="col">Observaciones</th>                            
                        </tr>
                    </thead>
                    
                    <tbody>
                        @if (isset($excel_data))
                            @foreach ($excel_data as $excel_row)
                                <tr id="mass_row_{{ $loop->index }}" @if ($excel_row->validation != "good") class="mass_row table-{{ $excel_row->validation }}" @else class="mass_row" @endif>
                                    <td >@if ($excel_row->validation_msg != "")<button class="btn " onclick="showModal('Precauciones' , '{{ $excel_row->validation_msg }}')"><i class="far fa-eye"></i></button>@endif</td>
                                    <td id="f{{ $loop->index }}_asset">{{ $excel_row->asset }}</td>
                                    <td id="f{{ $loop->index }}_descrip">{{ $excel_row->descrip }}</td>
                                    <td id="f{{ $loop->index }}_regimen">{{ $excel_row->regimen }}</td>
                                    <td id="f{{ $loop->index }}_brand">{{ $excel_row->brand }}</td>
                                    <td id="f{{ $loop->index }}_model">{{ $excel_row->model }}</td>
                                    <td id="f{{ $loop->index }}_serial">{{ $excel_row->serial }}</td>
                                    <td id="f{{ $loop->index }}_ubicacion">{{ $excel_row->ubicacion }}</td>
                                    <td id="f{{ $loop->index }}_pedimento">{{ $excel_row->pedimento }}</td>
                                    <td id="f{{ $loop->index }}_factura">{{ $excel_row->factura }}</td>
                                    <td id="f{{ $loop->index }}_fecha_pedimento_factura">{{ $excel_row->fecha_pedimento_factura }}</td>
                                    <td id="f{{ $loop->index }}_bandera">{{ $excel_row->bandera }}</td>
                                    <td id="f{{ $loop->index }}_observations">{{ $excel_row->observations }}</td>
                                </tr>
                            @endforeach
                        @endif
                    </tbody>
                </table>
                </div> 
                <div class="row" style="margin-top:20px;">
                    <div class="col-lg-9 controlDiv"></div>
                    <input type="button" class="col-lg-2 btn btn-success " value="Guardar" onclick="guardar()" {{ isset($import_id) && isset($is_valid) ? '' : 'disabled' }} >
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('scripts')
<script>

function subirArchivo()
{
    $("#frm_Cargar").submit();
}
function downloadTemplete()
{
    location.href = "/download_massive_template";
}
function cargar()
{
    $('#txtArchivo').click();
}
function guardar()
{
    @php
    if(isset($import_id))
    {
        echo 'let import_id = "' . $import_id . '";';
    } else {
        echo 'let import_id = null;';
    }
    if(isset($is_valid))
    {
        echo 'let is_valid = true;';
    } else {
        echo 'let is_valid = false;';
    }
    @endphp
    if(import_id == null)
    {
        showModal("Alerta!", "Hubo un error cargando el archivo. Contacte al departamento de sistemas." + import_id);
        return;
    }
    
    if($("#txtCliente").val() == 0)
    {
        showModal("Alerta!", "Llene el campo Cliente.");
        return;
    }

    location.href = "/assets_massive_save/"+import_id+'/'+$("#txtCliente").val();
    
}


</script>
@endsection