<?php $__env->startSection('headers'); ?>
<style>
    th{
        text-align:center;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- Page Heading -->
<header class="bg-white shadow">
    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Importe de Assets masivo
        </h2>
    </div>
</header>

<!-- Page Content -->
<div class="py-12">
    <div class="max-w-full mx-auto sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 bg-white border-b border-gray-200">

                <div class="row">

                    <div class="btn-group col-lg-4" role="group">
                        <button type="button" class="btn btn-outline-info" onclick="downloadTemplete()">Plantilla .xls <i class="fas fa-file-download"></i></button>
                        <button type="button" class="btn btn-outline-primary" onclick="cargar()">Cargar archivo <i class="fas fa-file-upload"></i></button>                        
                    </div>

                    <br>
                    <form id="frm_Cargar" action="/assets_massive_load" method="post" enctype="multipart/form-data">
                    <div style="display:none">
                        
                            <?php echo csrf_field(); ?>
                            <input type="file" id="txtArchivo" name="file" accept=".xlsx" onchange="subirArchivo()">
                    </div>
                    <label class="form-label" style="color: #B22222"> <strong>*NOTA:</strong> <i lang="it">El archivo a cargar debe contener unicamente 1 pestaña</i></label>
                    <br>
                    <div class="col-lg-3 controlDiv" >
                        <label class="form-label">Cliente:</label>
                        <select class="form-select" id = "txtCliente" name = "txtCliente" <?php if(isset($cliente)): ?> readonly <?php endif; ?>>
                        <option value=0 selected></option>
                        <?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clienteOp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($clienteOp->id); ?>" <?php if(isset($cliente)){if($cliente == $clienteOp->id){echo "selected ";}else{echo "disabled ";}}?> ><?php echo e($clienteOp->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    </form>
                </div>

                <br><br>
                <div style="overflow-x: auto; white-space: nowrap;">
                <table class="table table-sm table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th scope="col"><i class="fas fa-exclamation-triangle"></i></th>
                            <th scope="col">Asset</th>
                            <th scope="col">Descripcion</th>
                            <th scope="col">Regimen</th>
                            <th scope="col">Marca</th>
                            <th scope="col">Modelo</th>
                            <th scope="col">Serie</th>
                            <th scope="col">Ubicacion</th>
                            <th scope="col">Pedimento</th>
                            <th scope="col">Factura</th>
                            <th scope="col">Fecha pedimento</th>
                            <th scope="col">Bandera</th>
                            <th scope="col">Observaciones</th>                            
                        </tr>
                    </thead>
                    
                    <tbody>
                        <?php if(isset($excel_data)): ?>
                            <?php $__currentLoopData = $excel_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $excel_row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr id="mass_row_<?php echo e($loop->index); ?>" <?php if($excel_row->validation != "good"): ?> class="mass_row table-<?php echo e($excel_row->validation); ?>" <?php else: ?> class="mass_row" <?php endif; ?>>
                                    <td ><?php if($excel_row->validation_msg != ""): ?><button class="btn " onclick="showModal('Precauciones' , '<?php echo e($excel_row->validation_msg); ?>')"><i class="far fa-eye"></i></button><?php endif; ?></td>
                                    <td id="f<?php echo e($loop->index); ?>_asset"><?php echo e($excel_row->asset); ?></td>
                                    <td id="f<?php echo e($loop->index); ?>_descrip"><?php echo e($excel_row->descrip); ?></td>
                                    <td id="f<?php echo e($loop->index); ?>_regimen"><?php echo e($excel_row->regimen); ?></td>
                                    <td id="f<?php echo e($loop->index); ?>_brand"><?php echo e($excel_row->brand); ?></td>
                                    <td id="f<?php echo e($loop->index); ?>_model"><?php echo e($excel_row->model); ?></td>
                                    <td id="f<?php echo e($loop->index); ?>_serial"><?php echo e($excel_row->serial); ?></td>
                                    <td id="f<?php echo e($loop->index); ?>_ubicacion"><?php echo e($excel_row->ubicacion); ?></td>
                                    <td id="f<?php echo e($loop->index); ?>_pedimento"><?php echo e($excel_row->pedimento); ?></td>
                                    <td id="f<?php echo e($loop->index); ?>_factura"><?php echo e($excel_row->factura); ?></td>
                                    <td id="f<?php echo e($loop->index); ?>_fecha_pedimento_factura"><?php echo e($excel_row->fecha_pedimento_factura); ?></td>
                                    <td id="f<?php echo e($loop->index); ?>_bandera"><?php echo e($excel_row->bandera); ?></td>
                                    <td id="f<?php echo e($loop->index); ?>_observations"><?php echo e($excel_row->observations); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
                </div> 
                <div class="row" style="margin-top:20px;">
                    <div class="col-lg-9 controlDiv"></div>
                    <input type="button" class="col-lg-2 btn btn-success " value="Guardar" onclick="guardar()" <?php echo e(isset($import_id) && isset($is_valid) ? '' : 'disabled'); ?> >
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>

function subirArchivo()
{
    $("#frm_Cargar").submit();
}
function downloadTemplete()
{
    location.href = "/download_massive_template";
}
function cargar()
{
    $('#txtArchivo').click();
}
function guardar()
{
    <?php
    if(isset($import_id))
    {
        echo 'let import_id = "' . $import_id . '";';
    } else {
        echo 'let import_id = null;';
    }
    if(isset($is_valid))
    {
        echo 'let is_valid = true;';
    } else {
        echo 'let is_valid = false;';
    }
    ?>
    if(import_id == null)
    {
        showModal("Alerta!", "Hubo un error cargando el archivo. Contacte al departamento de sistemas." + import_id);
        return;
    }
    
    if($("#txtCliente").val() == 0)
    {
        showModal("Alerta!", "Llene el campo Cliente.");
        return;
    }

    location.href = "/assets_massive_save/"+import_id+'/'+$("#txtCliente").val();
    
}


</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.common', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/juanjacobo/Documents/GitHub/backup4practice/newer/ecex-portal/resources/views/intern/assets/masiva.blade.php ENDPATH**/ ?>