<?php $__env->startSection('headers'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- Page Heading -->
<header class="bg-white shadow">
    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Assets
        </h2>
    </div>
</header>

<!-- Page Content -->
<div class="py-12">
<div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
<div class="p-6 bg-white border-b border-gray-200">

<form id="AssetForm" action="/int/assets" method="POST" enctype="multipart/form-data">
<?php echo csrf_field(); ?>
<div class="row">
    <div class="col-lg-2 controlDiv" >
        <label class="form-label">Asset:</label>
        <input type="text" class="form-control" id="txtAsset" name="txtAsset" value="<?php echo e($asset?->asset ?? ''); ?>" style="text-align:center;" <?php if($asset != ''): ?> readonly <?php endif; ?>>       
    </div>
    <div class="col-lg-2 controlDiv" >
        <label class="form-label">Cliente:</label>
        <select class="form-select" id = "txtCliente" name = "txtCliente" <?php if(isset($cliente)): ?> readonly <?php endif; ?>>
        <option value=0 selected></option>
        <?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clienteOp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($clienteOp->id); ?>" <?php if(isset($cliente)){if($cliente == $clienteOp->id){echo "selected ";}else{echo "disabled ";}}?> ><?php echo e($clienteOp->name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <div class="col-lg-2 controlDiv" >
        <label class="form-label">Regimen:</label>
        <select class="form-select" id = "txtRegimen" name = "txtRegimen">
        <option value=0></option>
        <?php $__currentLoopData = $regimes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $regimeOp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($regimeOp->name); ?>" <?php if(isset($asset)){if($asset->regimen == $regimeOp->name){echo "selected";}}?> ><?php echo e($regimeOp->name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <div class="col-lg-3 controlDiv"></div>
    <div class="col-lg-3 controlDiv" style="text-align:center;">
        <div class="btn-group" role="group" <?php echo e(isset($asset) ? '' : 'style="display:none"'); ?>>
            <input type="button" class="col-lg-3 btn btn-warning " value="Registrar Salida" onclick="modoSalida()">
        </div>
        <div class="btn-group" role="group">
            <button type="button" class="btn btn-secondary" onclick="irMasiva()"><i class="fas fa-ellipsis-h"></i></button>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-lg-3 controlDiv" >
        <label class="form-label">Descripción:</label>
        <input type="text" class="form-control" id="txtDesc" name="txtDesc" value="<?php echo e($asset?->descrip ?? ''); ?>">       
    </div>
    <div class="col-lg-3 controlDiv" >
        <label class="form-label">marca:</label>
        <input type="text" class="form-control" id="txtMarca" name="txtMarca" value="<?php echo e($asset?->brand ?? ''); ?>">       
    </div>
    <div class="col-lg-3 controlDiv" >
        <label class="form-label">modelo:</label>
        <input type="text" class="form-control" id="txtModelo" name="txtModelo" value="<?php echo e($asset?->model ?? ''); ?>">       
    </div>
    <div class="col-lg-3 controlDiv" >
        <label class="form-label">serie:</label>
        <input type="text" class="form-control" id="txtSerie" name="txtSerie" value="<?php echo e($asset?->serial ?? ''); ?>">       
    </div>
</div>
<div class="row">
    
    <div class="col-lg-3 controlDiv" >
        <label class="form-label">Ubicacion:</label>
        <input type="text" class="form-control" id="txtUbicacion" name="txtUbicacion" value="<?php echo e($asset?->ubicacion ?? ''); ?>">       
    </div>
    <div class="col-lg-3 controlDiv" >
        <label class="form-label">Pedimento:</label>
        <input type="text" class="form-control" id="txtPedimento" name="txtPedimento" value="<?php echo e($asset?->pedimento ?? ''); ?>">       
    </div>
    <div class="col-lg-3 controlDiv" >
        <label class="form-label">Factura:</label>
        <input type="text" class="form-control" id="txtFactura" name="txtFactura" value="<?php echo e($asset?->factura ?? ''); ?>">       
    </div>
    <div class="col-lg-3 controlDiv" >
        <label class="form-label">Fecha pedimento a Factura:</label>
        <input type="date" class="form-control" id="txtFecha" name="txtFecha" value="<?php if(isset($asset?->fecha_pedimento_factura)): ?><?php echo e(explode(' ',$asset?->fecha_pedimento_factura)[0]); ?><?php else: ?><?php echo e(date('Y-m-d')); ?><?php endif; ?>">
    </div>
    <div class="col-lg-3 controlDiv" >
        <label class="form-label">Bandera:</label>
        <select class="form-select" id = "txtBandera" name = "txtBandera">
        <option value=0 selected></option>
            <option value="Rojo" <?php if($asset?->bandera == 'ROJO'): ?> selected <?php endif; ?>>Rojo</option>
            <option value="Amarillo" <?php if($asset?->bandera == 'AMARILLO'): ?> selected <?php endif; ?>>Amarillo</option>
            <option value="Verde" <?php if($asset?->bandera == 'VERDE'): ?> selected <?php endif; ?>>Verde</option>
        </select>
    </div>
    
</div>

<div class="mb-3">
    <label class="form-label">Observaciones</label>
    <textarea class="form-control" id="txtObservaciones" name="txtObservaciones" rows="2"><?php echo e($asset?->observations ?? ''); ?></textarea>
</div>

<div class="row">
    <div class="col-lg-3 controlDiv" >
        <label class="form-label">Fotos:</label>
        <input type="file" id="txtFotos" name="fotos[]" accept="image/*" multiple>    
    </div>
    <div class="col-lg-3 controlDiv" >
        <label class="form-label">PDF's:</label>
        <input type="file" id="txtArchivos" name="archivos[]" accept="application/pdf" multiple>    
    </div>
</div>

<div class="row" id="motivo_de_salida_div" <?php if($asset?->status != 'Salida'): ?> style='display:none' <?php endif; ?>>
    <div class="col-lg-3 controlDiv" >
        <label class="form-label">Salida:</label>
        <select class="form-select" id = "txtStatus" name = "txtStatus" onChange='onStatusChange(this)'>
        <option value=0 selected></option>
            <option value="Entrada" <?php if($asset?->status == 'Entrada'): ?> selected <?php endif; ?>>No</option>
            <option value="Salida" <?php if($asset?->status == 'Salida'): ?> selected <?php endif; ?>>Si</option>
        </select>
    </div>
    <div class="col-lg-3 controlDiv" >
        <label class="form-label">Motivo de Salida:</label>
        <input type="text" class="form-control" id="txtMotivoDeSalida" name="txtMotivoDeSalida" value="<?php echo e($asset?->motivo_de_salida ?? ''); ?>">       
    </div>
</div>

<div class="row" style="margin-top:20px;">
    <div class="col-lg-6 controlDiv"></div>
    <input type="button" class="col-lg-2 btn btn-danger " value="Cancelar" onclick="cancel()">
    <div class="col-lg-1 controlDiv"></div>
    <input type="button" class="col-lg-3 btn btn-success " value="Guardar" onclick="guardar()">
</div>
<div class="row" style="margin-top:20px;" <?php if(!isset($asset?->id)): ?> style='display:none' <?php endif; ?>>
    <div class="col-lg-5 controlDiv" >
        <button type="button" class="col-lg-2 btn btn-light" style="margin-right:20px" onclick="irAQR(<?php echo e($asset?->id); ?>)">Imprimir etiquetas <i class="fa-solid fa-print"></i></button>
    </div>
</div>
<div class="row" style="margin-top:20px;">
    <label><?php echo e($asset?->user ?? ''); ?></label>
</div>
</form>
<br/>
<br/>
<?php
    if($asset?->getFotosURLs() != null)
    {
        echo '<div class="row">';
        echo '<div class="col-lg-10 controlDiv" >';
        echo '    <div class="accordion" id="accordionExample">';
        echo '        <div class="accordion-item">';
        echo '            <h2 class="accordion-header" id="headingOne">';
        echo '                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">';
        echo '                    Archivos existentes';
        echo '                </button>';
        echo '            </h2>';
        echo '            <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">';
        echo '                <div class="accordion-body">';
            // foreach($asset->getFotosURLs() as $foto)
            // {
            //     echo '<p>'.$foto.'</p>';
            // }
                                    
        if(isset($asset?->id))
        {
            $income_imgs_paths='public/assets_files/'.$asset?->id.'/images/';
            $income_imgs = Storage::files($income_imgs_paths);
            foreach ($income_imgs as $income_img) 
            {
                $img_file_name_array=explode('/',$income_img);
                $img_file_name=$img_file_name_array[count($img_file_name_array)-1];
                $img_file_url='storage/assets_files/'.$asset?->id.'/images/'.$img_file_name;
                echo "<div class='img_card col-lg-3'>";
                echo "    <div class='img_card_top'>";
                echo "        <h6><b>".$img_file_name."</b><button onclick='deleteImg(\"".$img_file_name."\")'><i class='fas fa-times'></i></button></h6>"; 
                echo "    </div>";
                echo "    <img src='".asset($img_file_url)."'>";
                echo "</div>";
            }
        }
            
        echo '                </div>';
        echo '            </div>';
        echo '        </div>';
        echo '    </div>';
        echo '</div>';
        echo '</div>';
    }
?>
</div>
</div>
</div>
</div>

<div style="display:none">
<form id="AssetImgDeleteForm" action="/int/delete_asset_foto/" method="post" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <input type="text" id="asset_foto_name" name="asset_foto_name">
    <input style="hidden" type="text" id="asset_id" name="asset_id" value=<?php echo e($asset?->id); ?>>
</form>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>

function guardar()
{
    //validaciones
    if($("#txtAsset").val().length < 1)
    {
        showModal("Alerta!", "Llene el campo Asset.");
        return;
    }
    if($("#txtCliente").val() == 0)
    {
        showModal("Alerta!", "Llene el campo Cliente.");
        return;
    }
    document.getElementById("AssetForm").submit();
}
function deleteImg(img_name)
{
    if (confirm("Desea eliminar esta imagen?"+' '+img_name))
    {
        $("#asset_foto_name").val(img_name);
        $("#AssetImgDeleteForm").submit();
    }
}

function cancel()
{
    location.href = "/int/assets/";
}
$( document ).ready(function() {
    // en caso de que requiera ejecutar algo al cargar la pagina
});

function irMasiva()
{
    if($("#txtCliente").val() == 0)
    {
        showModal("Alerta!", "Llene el campo Cliente.");
        return;
    }
    location.href="/assets_massive/"+$("#txtCliente").val();
}

function modoSalida()
{
    // $("#txtAsset").disabled = true;
    // document.getElementById('txtCliente').disabled = true;
    // document.getElementById('txtDesc').disabled = true;
    // document.getElementById('txtMarca').disabled = true;
    // document.getElementById('txtModelo').disabled = true;
    // document.getElementById('txtSerie').disabled = true;
    // document.getElementById('txtUbicacion').disabled = true;
    // document.getElementById('txtPedimento').disabled = true;
    // document.getElementById('txtFecha').disabled = true;
    // document.getElementById('txtBandera').disabled = true;
    // document.getElementById('txtObservaciones').disabled = true;
    // document.getElementById('txtFotos').disabled = true;
    // document.getElementById('txtArchivos').disabled = true;
    mostrarMotivoDeSalida();
    document.getElementById('txtStatus').value = 'Salida';
    document.getElementById('txtMotivoDeSalida').focus();
}

function mostrarMotivoDeSalida()
{
    document.getElementById('motivo_de_salida_div').style.display = 'block';
}

function onStatusChange(e)
{
    if(e.value == 'Entrada')
    {
        document.getElementById('motivo_de_salida_div').style.display = 'none';
    } else {
        document.getElementById('motivo_de_salida_div').style.display = 'block';
    }
}
function irAQR(asset_id)
{
    location.href = "/int/asset_etiqueta/" + asset_id;
}

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.common', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/juanjacobo/Documents/GitHub/backup4practice/newer/ecex-portal/resources/views/intern/assets/create.blade.php ENDPATH**/ ?>