<?php $__env->startSection('headers'); ?>
<style>
    td, th
    {
        text-align:center;
    }
    .oversized-col
    {
        max-width:150px;
        overflow:hidden;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- Page Heading -->
<header class="bg-white shadow">
    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Assets.
        </h2>
    </div>
</header>

<!-- Page Content -->

<div class="py-12">
<div class="max-w-full mx-auto sm:px-6 lg:px-8">
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
<div class="p-6 bg-white border-b border-gray-200">

        <form id = "frmAssets" action="/int/assets" method="get">
        <div class="row">
            <div class="col-lg-2 controlDiv" >
                <label class="form-label">Cliente:</label>
                <select class="form-select" id = "txtCliente" name = "txtCliente">
                <option value=0 selected></option>
                <?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clienteOp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($clienteOp->id); ?>" <?php if( $cliente == $clienteOp->id): ?> selected <?php endif; ?> ><?php echo e($clienteOp->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-lg-2 controlDiv" style="">
                <label class="form-label">Asset / Descripción:</label>
                <input type="text" class="form-control" id="txtDesc" name="txtDesc" value="<?php echo e($desc ?? ''); ?>">       
            </div>

            <div class="col-lg-3 controlDiv" >
                <label class="form-label">Salida:</label>
                <select class="form-select" id = "txtStatus" name = "txtStatus" onChange='onStatusChange(this)'>
                <option value=0 selected></option>
                    <option value="Entrada" <?php if($status == '0'): ?> selected <?php endif; ?>></option>
                    <option value="Entrada" <?php if($status == 'Entrada'): ?> selected <?php endif; ?>>No</option>
                    <option value="Salida" <?php if($status == 'Salida'): ?> selected <?php endif; ?>>Si</option>
                </select>
            </div>

            <div class="col-lg-2 controlDiv" style="position:relative;top:30px;">
                <button type="button" class="btn btn-primary" onclick="buscar()">Buscar</button>     
            </div>
            <div class="col-lg-2 controlDiv" style="position:relative;top:30px;">
                <a href="/int/assets/create" class="btn btn-success" role="button" aria-pressed="true"><i class="fas fa-plus"></i></a>
            </div>
            
        </div>
        <br><br>

            <div class="row" >
                <input type="hidden" id="txtTab" name="txtTab" value="<?php echo e($tab ?? 1); ?>">

                <div class="col-lg-10 controlDiv" style="overflow: auto; text-align:center; left:100px; position:relative;">
                    <div class="btn-group me-2" id="div_btns_partidas" role="group">
                    <button type='button' class='btn btn-outline-primary btnIncomeRow' onclick='goPrev()' id='btnTab_prev'><span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span></button>
                        <?php
                        if(isset($tab_count))
                        {
                            for ($i = 1; $i <= $tab_count+1; $i++)
                            {
                                $active_tab = "";
                                if($tab == $i)
                                {
                                    $active_tab = "active";
                                }
                                echo "<button type='button' class='btn btn-outline-secondary btnIncomeRow ".$active_tab."' onclick='goTab(".$i.")' id='btnTab_".$i."' >".$i."</button>";
                            }
                        }
                        ?>
                        <button type='button' class='btn btn-outline-primary btnIncomeRow' onclick='goNext()' id='btnTab_prev'><span aria-hidden="true">&raquo;</span><span class="sr-only">Previous</span></button>
                    </div>
                </div>
            </div>
            
        </form>

        <h5 class="separtor">Lista:</h5>



        <!-- como esta pantalla no contiene formularios debemos agregar uno para tener un token csrf-->
        <form method="DELETE">
        <?php echo csrf_field(); ?>
        </form>
        <table class="table table-sm table-striped table-bordered table-hover">
            <thead>
                <tr>
                    <th scope="col">Asset</th>
                    <th scope="col">Cliente</th>
                    <th scope="col">Descripcion</th>
                    <th scope="col">Regimen</th>
                    <th scope="col">Marca</th>
                    <th scope="col">Modelo</th>
                    <th scope="col">Serie</th>
                    <th scope="col">Ubicacion</th>
                    <th scope="col">Pedimento</th>
                    <th scope="col">Factura</th>
                    <?php if($can_edit): ?> <th scope="col">Editar</th> <?php endif; ?>
                    <?php if($can_delete): ?> <th scope="col">Eliminar</th> <?php endif; ?>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $assets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asset): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr id="row_<?php echo e($asset->id); ?>">
                    <td style="font-size:0.9em"><?php echo e($asset->asset); ?></td>
                    <td><?php echo e($asset->customer->name); ?></td>
                    <td style="font-size:0.8em; min-width:110px;"><?php echo e($asset->descrip); ?></td>
                    <td><?php echo e($asset->regimen); ?></td>
                    <td><?php echo e($asset->brand); ?></td>
                    <td><?php echo e($asset->model); ?></td>
                    <td><?php echo e($asset->serial); ?></td>
                    <td><?php echo e($asset->ubicacion); ?></td>
                    <td><?php echo e($asset->pedimento); ?></td>
                    <td><?php echo e($asset->factura); ?></td>
                    <?php if($can_edit): ?> <td><a href="/int/asset/<?php echo e($asset->id); ?>/edit_existing" class="btn btn-light" role="button" aria-pressed="true"><i class="fas fa-edit"></i></a></td> <?php endif; ?>
                    <?php if($can_delete): ?> <td><button class="btn btn-light" type='button' onclick="eliminar(<?php echo e($asset->id); ?>)"><i class="fas fa-times" style="color:red"></i></button></td> <?php endif; ?>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
</div>
</div>
</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>


function eliminar(id)
{
    if(!confirm("¿Desea eliminar el Asset?"))
    {
        return;
    }
    let token = $("[name='_token']").val();
    $.ajax(
        {
            url: "/int/assets/"+id,
            type: 'DELETE',
            data: {
                "_token": token,
            },
            success: function (response){
                showModal("Notificación",response);
                if(response == "Eliminado!")
                {
                    $("#row_"+id).remove();
                }
            }
        });
}

function buscar()
{
    $("#txtTab").val("1");
    $("#frmAssets").submit();
}
function goTab(tab)
{
    $("#txtTab").val(tab);
    $("#frmAssets").submit();
}
function goPrev()
{
    var current_tab = Number($("#txtTab").val());    
    $("#txtTab").val(current_tab-1);
    $("#frmAssets").submit();
}
function goNext()
{
    var current_tab = Number($("#txtTab").val());
    $("#txtTab").val(current_tab+1);
    $("#frmAssets").submit();
}
function editar(id)
{
    location.href = "/int/asset/"+id+"/edit";
}


</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.common', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/juanjacobo/Documents/GitHub/backup4practice/newer/ecex-portal/resources/views/intern/assets/index.blade.php ENDPATH**/ ?>