<?php $__env->startSection('headers'); ?>
<style>
    td, th
    {
        text-align:center;
    }
    .oversized-col
    {
        max-width:150px;
        overflow:hidden;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- Page Heading -->
<header class="bg-white shadow">
    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Números de parte.
        </h2>
    </div>
</header>

<!-- Page Content -->

<div class="py-12">
<div class="max-w-full mx-auto sm:px-6 lg:px-8">
<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
<div class="p-6 bg-white border-b border-gray-200">

        <form id = "frmPartNumber" action="/part_number" method="get">
        <div class="row">
            <div class="col-lg-2 controlDiv" >
                <label class="form-label">Cliente:</label>
                <select class="form-select" id = "txtCliente" name = "txtCliente">
                <option value=0 selected></option>
                <?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clienteOp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($clienteOp->id); ?>" <?php if( $cliente == $clienteOp->id): ?> selected <?php endif; ?> ><?php echo e($clienteOp->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-lg-2 controlDiv" style="">
                <label class="form-label">#NP / Descripción:</label>
                <input type="text" class="form-control" id="txtDesc" name="txtDesc" value="<?php echo e($desc ?? ''); ?>" placeholder="#NP / Desc. Inglés / Español">       
            </div>

            <div class="col-lg-2 controlDiv" style="position:relative;top:30px;">
                <button type="button" class="btn btn-primary" onclick="buscar()">Buscar</button>     
            </div>
            <div class="col-lg-2 controlDiv" style="position:relative;top:30px;">
                <a href="/part_number/create" class="btn btn-success" role="button" aria-pressed="true"><i class="fas fa-plus"></i></a>
            </div>
            
        </div>
        <br><br>

            <div class="row" >
                <input type="hidden" id="txtTab" name="txtTab" value="<?php echo e($tab ?? 1); ?>">

                <div class="col-lg-10 controlDiv" style="overflow: auto; text-align:center; left:100px; position:relative;">
                    <div class="btn-group me-2" id="div_btns_partidas" role="group">
                    <button type='button' class='btn btn-outline-primary btnIncomeRow' onclick='goPrev()' id='btnTab_prev'><span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span></button>
                        <?php
                        if(isset($tab_count))
                        {
                            for ($i = 1; $i <= $tab_count+1; $i++)
                            {
                                $active_tab = "";
                                if($tab == $i)
                                {
                                    $active_tab = "active";
                                }
                                echo "<button type='button' class='btn btn-outline-secondary btnIncomeRow ".$active_tab."' onclick='goTab(".$i.")' id='btnTab_".$i."' >".$i."</button>";
                            }
                        }
                        ?>
                        <button type='button' class='btn btn-outline-primary btnIncomeRow' onclick='goNext()' id='btnTab_prev'><span aria-hidden="true">&raquo;</span><span class="sr-only">Previous</span></button>
                    </div>
                </div>
            </div>
            
        </form>

        <h5 class="separtor">Lista:</h5>



        <!-- como esta pantalla no contiene formularios debemos agregar uno para tener un token csrf-->
        <form method="DELETE">
        <?php echo csrf_field(); ?>
        </form>
        <table class="table table-sm table-striped table-bordered table-hover">
            <thead>
                <tr>
                    <th scope="col">Número_de_Parte</th>
                    <th scope="col">Cliente</th>
                    <th scope="col">um</th>
                    <th scope="col">Peso u.</th>
                    <th scope="col">Desc_Ing</th>
                    <th scope="col">Desc_Esp</th>
                    <th scope="col">Pais</th>
                    <th scope="col">Fraccion.nico</th>
                    <th scope="col">Marca</th>
                    <th scope="col">Modelo</th>
                    <th scope="col">Serie</th>
                    <th scope="col">IMMEX</th>
                    <th scope="col">Regimen</th>
                    <th scope="col">observaciones</th>
                    <?php if($can_edit): ?> <th scope="col">Editar</th> <?php endif; ?>
                    <?php if($can_delete): ?> <th scope="col">Eliminar</th> <?php endif; ?>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $part_numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $part_number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr id="pn_row_<?php echo e($part_number->id); ?>">
                    <td style="font-size:0.9em"><?php echo e($part_number->part_number); ?></td>
                    <td><?php echo e($part_number->customer->name); ?></td>
                    <td><?php echo e($part_number->um); ?></td>
                    <td><?php echo e($part_number->unit_weight); ?></td>
                    <td style="font-size:0.8em; min-width:110px;"><?php echo e($part_number->desc_ing); ?></td>
                    <td style="font-size:0.8em; min-width:110px;"><?php echo e($part_number->desc_esp); ?></td>
                    <td><?php echo e($part_number->origin_country); ?></td>
                    <td><?php echo e($part_number->fraccion); ?>.<?php echo e($part_number->nico); ?></td>
                    <td><?php echo e($part_number->brand); ?></td>
                    <td><?php echo e($part_number->model); ?></td>
                    <td><?php echo e($part_number->serial); ?></td>
                    <td><?php echo e($part_number->imex); ?></td>
                    <td><?php echo e($part_number->regime); ?></td>
                    <td style="font-size:0.7em; min-width:110px;"><?php echo e($part_number->fraccion_especial); ?></td>
                    <?php if($can_edit): ?> <td><a href="/part_number/<?php echo e($part_number->id); ?>/edit_existing" class="btn btn-light" role="button" aria-pressed="true"><i class="fas fa-edit"></i></a></td> <?php endif; ?>
                    <?php if($can_delete): ?> <td><button class="btn btn-light" type='button' onclick="eliminar(<?php echo e($part_number->id); ?>)"><i class="fas fa-times" style="color:red"></i></button></td> <?php endif; ?>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
</div>
</div>
</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>


function eliminar(id)
{
    if(!confirm("¿Desea eliminar el asset?"))
    {
        return;
    }
    let token = $("[name='_token']").val();
    $.ajax(
        {
            url: "/assets/"+id,
            type: 'DELETE',
            data: {
                "_token": token,
            },
            success: function (response){
                showModal("Notificación",response);
                if(response == "Eliminado!")
                {
                    $("#pn_row_"+id).remove();
                }
            }
        });
}

function buscar()
{
    $("#txtTab").val("1");
    $("#frmPartNumber").submit();
}
function goTab(tab)
{
    $("#txtTab").val(tab);
    $("#frmPartNumber").submit();
}
function goPrev()
{
    var current_tab = Number($("#txtTab").val());    
    $("#txtTab").val(current_tab-1);
    $("#frmPartNumber").submit();
}
function goNext()
{
    var current_tab = Number($("#txtTab").val());
    $("#txtTab").val(current_tab+1);
    $("#frmPartNumber").submit();
}
function editar(id)
{
    location.href = "/part_number/"+id+"/edit";
}


</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.common', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/juanjacobo/Documents/GitHub/backup4practice/newer/ecex-portal/resources/views/intern/part_number/index.blade.php ENDPATH**/ ?>